package fr.asip.cps3.exemple.vues.menus;

import fr.asip.cps3.exemple.modele.objets.Algo;

/**
 * Classe modlisant un menu de type Algorithme
 *
 */
public class MenuAlgo extends Menu {
	
	private static final long serialVersionUID = 6222298973813709020L;
	
	/**
	 * Algorithme associ  l'item de menu
	 */
	private Algo algo;

	/**
	 * Constructeur  5 arguments
	 * @param algo Algorithme associ au menu
	 * @param idParent Identifiant du menu parent
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 */
	public MenuAlgo(Algo algo, String idParent, boolean enable, boolean visible) {
		
		super(idParent+",", idParent, "", enable, visible);
		this.algo = algo;
		if(algo != null) {
			setId(getIdParent()+","+algo.getIdAlgo());
			setText(algo.getLibelle());
		}
		
	}

	/**
	 * Accesseur
	 * @return Algorithme associ  l'item de menu
	 */
	public Algo getAlgo() {
		return algo;
	}
}
